﻿using System;

namespace ListsAndCollections.NotTheRealInterfaces
{
    // UWAGA: to wszystko są kopie prawdziwych interfejów, pokazane tu tylko po to
    // by Czytelnik mógł zobaczyć jak wyglądają. Nie należy próbować stosować ich 
    // w prawdziwym kodzie, gdyż żadne inne klasy .NET ich nie rozpoznają. (CLR nie dysponuje
    // mechanizmem określającym strukturalną równoważność swych własnych typów danych.)

    // Listing 5-24
    public interface IEnumerable<out T> : IEnumerable
    {
        IEnumerator<T> GetEnumerator();
    }

    public interface IEnumerable
    {
        IEnumerator GetEnumerator();
    }

    // Listing 5-25
    public interface IEnumerator<out T> : IDisposable, IEnumerator
    {
        T Current { get; }
    }

    public interface IEnumerator
    {
        bool MoveNext();
        object Current { get; }
        void Reset();
    }

    // Listing 5-26
    public interface ICollection<T> : IEnumerable<T>, IEnumerable
    {
        void Add(T item);
        void Clear();
        bool Contains(T item);
        void CopyTo(T[] array, int arrayIndex);
        bool Remove(T item);

        int Count { get; }
        bool IsReadOnly { get; }
    }

    // Listing 5-27
    public interface IList<T> : ICollection<T>, IEnumerable<T>, IEnumerable
    {
        int IndexOf(T item);
        void Insert(int index, T item);
        void RemoveAt(int index);

        T this[int index] { get; set; }
    }

}
